<?php 
add_action( 'add_meta_boxes', 'ct_add_custom_box' );

function ct_add_custom_box() {
	
	//if( !ct_check_if_valid() ) return false;
	global $current_user;
		add_meta_box( 
			'ct_new_product',
			__( 'Easy Countdown', 'db_domain' ),
			'ct_magic_countdown',
			'post' , 'side', 'high'
		);
		add_meta_box( 
			'ct_new_product',
			__( 'Easy Countdown', 'db_domain' ),
			'ct_magic_countdown',
			'page' , 'side', 'high'
		);
		
}


function ct_magic_countdown(){
	
	global $post;
	global $current_user;
	wp_nonce_field ( plugin_basename( __FILE__ ), 'myplugin_noncename' );
	//wp_nonce_field ( plugin_basename ( __FILE__ ), 'mcc_timer_reset' );
	
	$post_option = 'mark_'.$post->ID.'_'.$_SERVER['REMOTE_ADDR'];
	echo '
	<div class="tw-bs">
	
		<div class="form-horizontal">  
		
			<fieldset>  
			
				<font style="font-size: 10pt;"><b>Redirect Options</b></font><br />
				
				<div class="control-group">  
					<label class="radio"> 
						<input type="radio" name="timer_type" id="optionsRadios2" '.( get_post_meta( $post->ID, 'timer_type', true ) == 'date_timer' ? ' checked ' : '' ).' value="date_timer">
						Specific Date<br/>
						<input type="text" class="input-xsmall timepicker" name="specific_date" id="specific_date"  value="'.get_post_meta( $post->ID, 'specific_date', true ).'" > 
					</label> 
				</div>

				<div class="control-group"> 
				 
					<label class="radio"> 
					<input type="radio" name="timer_type" '.( get_post_meta( $post->ID, 'timer_type', true ) == 'each_timer' ? ' checked ' : '' ).' value="each_timer">
					Time Based on each visitor<br/>
					</label>
					
					<div>
					
						<div  class="fl_l_small">
							Days
						</div>
						<div  class="fl_l_small">
							<input type="text" class="input-xmini" name="in_days" id="in_days" value="'.( get_post_meta( $post->ID, 'in_days', true ) ? get_post_meta( $post->ID, 'in_days', true ) : '00' ).'" />
						</div>
						<div  class="fl_l_small">
							Hours
						</div>
						<div  class="fl_l_small">
							<input type="text" class="input-xmini" name="in_hours" id="in_hours"  value="'.( get_post_meta( $post->ID, 'in_hours', true ) ? get_post_meta( $post->ID, 'in_hours', true ) : '00').'" />
						</div>
						<div  class="fl_l_small">
							Mins
						</div>
						<div class="fl_l_small" >
							<input type="text" class="input-xmini" name="in_minutes" id="in_mins"  value="'.( get_post_meta( $post->ID, 'in_minutes', true ) ? get_post_meta( $post->ID, 'in_minutes', true ) : '00' ).'" />
						</div>

						<div class="clearfix"></div>
						
					</div>

					<div class="control-group">  
						<label class="control-label1" for="input01"><b>Redirect URL</b> ( after time expires )</label>  
						<div class="controls1">  
						<input type="text" class="input-xsmall" name="redirect_url" id="redirect_url" value="'.get_post_meta( $post->ID, 'redirect_url', true ).'" >  
					</div>  
					
				</div>  

				<div class="form-actions1">  
					<button type="button" class="btn btn-primary" id="insert_shortcode" >Insert Countdown</button>   
					<button type="button" class="btn" id="reset_counter" >Reset Countdown</button>    
				</div>  
				
			</fieldset>  
			
		</div>

		<script>
		jQuery( document ).ready( function($) {

			// Setup a click handler to initiate the Ajax request and handle the response
			$("#reset_counter").click(function(event) {
			
				event.preventDefault();

				// Use jQuery"s post method to send the request to the server. The "ajaxurl" is a URL
				// provided by WordPress" Ajax API.
				$.post(ajaxurl, {

					action:	"mcc_timer_reset", // The function located in plugin.php for handling the request
					nonce: 	"' . wp_create_nonce( "reset_counter" ) . '", // The security nonce
					mcc_post_option: "' . $post_option . '"

				}, function(response) {

					//$( "#ct_new_product .inside" ).prepend( response );
					//$( ".updated.fade" ).fadeOut( 5000 );

				});

			});

		});
		</script>

	</div>	
	';
	
}


add_action( 'save_post', 'ct_save_postdata' );

function ct_save_postdata( $post_id ) {
	
global $current_user; 

 if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
      return;
	  
  if ( !wp_verify_nonce( $_POST['myplugin_noncename'], plugin_basename( __FILE__ ) ) )
      return;
  if ( 'page' == $_POST['post_type'] ) {
    if ( !current_user_can( 'edit_page', $post_id ) )
        return;
  } else {
    if ( !current_user_can( 'edit_post', $post_id ) )
        return;
  }
  
  // User editotions
  
  if( get_post_type( $post_id ) == 'post' || get_post_type( $post_id ) == 'page' ){
	  
	update_post_meta( $post_id, 'timer_type', $_POST['timer_type'] );
	update_post_meta( $post_id, 'specific_date', $_POST['specific_date'] );
	
	
	update_post_meta( $post_id, 'in_days', $_POST['in_days'] );
	update_post_meta( $post_id, 'in_hours', $_POST['in_hours'] );
	update_post_meta( $post_id, 'in_minutes', $_POST['in_minutes'] );
	update_post_meta( $post_id, 'redirect_url', $_POST['redirect_url'] );
  
  }
  
}


/**
 * Reset magiccounter when is time based (not "date" based)
 */
 
add_action('wp_ajax_mcc_timer_reset', 'mcc_timer_reset');
add_action('wp_ajax_nopriv_mcc_timer_reset', 'mcc_timer_reset');

function mcc_timer_reset () {

	if( ! empty( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && strtolower( $_SERVER['HTTP_X_REQUESTED_WITH'] ) == 'xmlhttprequest' ) {

		if( wp_verify_nonce($_POST['nonce'],'reset_counter') ){
			
		} else {
			
			die();
			
		}
		
	}
	
	delete_option ( $_POST['mcc_post_option'] );

	if( ! empty( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && strtolower( $_SERVER['HTTP_X_REQUESTED_WITH'] ) == 'xmlhttprequest' ) {
			
		die();
		
	}
		
}

?>
