<?php 
add_shortcode( 'timer', 'ct_shortcode_handler' );
function ct_shortcode_handler( $atts, $content = null ) {
	
	global $post;
	$redirect_url = $atts['url'];

	$use_redirect = 0;
	$now = time(); // or your date as well

	//if( !ct_check_if_valid() ) return false;
	
	//delete_option('mark_'.$post->ID.'_'.$_SERVER['REMOTE_ADDR']);
	

	if( $atts['date'] ) {
		
		//processing date
		$start_date = strtotime( $atts['date'] );
		
		$datediff = $start_date - $now;

	} else if ( $atts['mins'] ) {
		
		$out_arr = explode( ':',$atts['mins'] );
		$time_fixed = $out_arr[0]*24*60*60 + $out_arr[1]*60*60 + $out_arr[2]*60 + $out_arr[3];
			
		//processing time
		if( get_option('mark_'.$post->ID.'_'.$_SERVER['REMOTE_ADDR']) ){
			
			$start_date = get_option('mark_'.$post->ID.'_'.$_SERVER['REMOTE_ADDR'] );
			$passed_seconds = $now - $start_date;

			$datediff = $time_fixed - $passed_seconds;	
			
		} else {
			
			update_option( 'mark_'.$post->ID.'_'.$_SERVER['REMOTE_ADDR'], $now );
			$start_date = $now;
			
			$datediff = $time_fixed;
			
		}
		
	}

	
	$days = floor($datediff/(60*60*24)) ;

	if( $datediff <= 0 ){
		$use_redirect = 1;
	}
	
	if( (int)date( 'z' , $datediff) >= 10 ){
		$prefix = '';
	} else if( (int)date( 'z' , $datediff) < 10 ){
		$prefix = '0';
	}

	$new_date = $prefix . $days.':'.date( 'H:i:s' , $datediff );

	//process zeros
	$date_format = 'dd:hh:mm:ss';
	$split_res = explode( ':', $new_date );

	if( $split_res[0] == '0' || $split_res[0] == '00' ) {
		
		$new_date = $split_res[1].':'.$split_res[2].':'.$split_res[3];
		$date_format = 'hh:mm:ss';
		
		if( $split_res[1] == '0' || $split_res[1] == '00' ) {
			
			$new_date = $split_res[2].':'.$split_res[3];
			$date_format = 'mm:ss';
		
			if( $split_res[2] == '0' || $split_res[2] == '00' ) {
				
				$new_date = $split_res[3];
				$date_format = 'ss';
				
			}
			
		}
		
	}

	$out .='
	
	<div class="wrapper">
		<div id="holder">
			<div class="digits">
			</div>
		</div>	
	</div>
	
	<script>
	jQuery( document ).ready( function(){
		jQuery(".digits").countdown({
			image: "'.plugins_url( 'images/digits.png', __FILE__ ).'",
			startTime: "'.$new_date.'",	
			format: "'.$date_format.'",
			timerEnd: function() { 
				var redirect_url = "' . $redirect_url . '";
				if ( redirect_url != "" ) {
					window.location.href="' . $redirect_url . '";
				} else {
				}
			},
		});
	});
	</script>';

	if ( $datediff > 0 ) {
		return $out; 
	}
	
	echo ( '
	<script>
		function mcc_redirect () {
			var redirect_url = "' . $redirect_url . '";
			if ( redirect_url != "" ) {
				window.location.href="' . $redirect_url . '";
			} else {
			}
		}
	</script>'
	);

	if( $use_redirect == 1 ) {
		echo ( '
		<script>
			mcc_redirect();
		</script>'
		);
	}
	
}

?>
